unit threadlogUnit;

{* Delphi Streaming Radio Library
 * Copyright 2004-2007, Steve Blinch
 * http://code.blitzaffe.com
 * ============================================================================
 *
 * LICENSE
 *
 * This code is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *	
 * You should have received a copy of the GNU General Public License along
 * with this code; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *}

interface

uses Classes,rawbufferUnit;

const
  MSG_THREADLOG = 1501;

  LL_NORMAL    = 1;
  LL_VERBOSE   = 2;
  LL_DEBUG     = 3;
  
Type
  TThreadMsg = record
      Buffer: TRawBuffer;
      Thread: TThread;
      LogLevel: Integer;
    end;
  PThreadMsg = ^TThreadMsg;
  TThreadLog = class(TObject)
    private
      FWindowHandle: THandle;
      FThread: TThread;
    public
      constructor Create(WindowHandle: THandle; Thread: TThread);
      destructor Destroy; override;
      procedure Log(Msg: String; Level: Integer);
    end;

implementation

uses Messages,Windows;

constructor TThreadLog.Create(WindowHandle: THandle; Thread: TThread);
begin
  FWindowHandle:=WindowHandle;
  FThread:=Thread;
end;

destructor TThreadLog.Destroy;
begin
  inherited;
end;

procedure TThreadLog.Log(Msg: String; Level: Integer);
var ThreadMsg: PThreadMsg;
begin
  New(ThreadMsg);
  {$IFDEF MEMDEBUG}kmnamepointer(ThreadMsg, 'ThreadLog.ThreadMsg:'+PointerCounter);{$ENDIF}
  ThreadMsg^.Buffer:=TRawBuffer.Create(Length(Msg));
  ThreadMsg^.Buffer.StoreString(Msg);
  ThreadMsg^.Thread:=FThread;
  ThreadMsg^.LogLevel:=Level;
  PostMessage(FWindowHandle,WM_USER,MSG_THREADLOG,Integer(ThreadMsg));
end;

end.
